% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetBonuses.R
\name{GetBonuses}
\alias{GetBonuses}
\alias{getbonuses}
\alias{bonuses}
\alias{ListBonusPayments}
\alias{listbonuspayments}
\title{Get Bonus Payments}
\usage{
GetBonuses(assignment = NULL, hit = NULL, hit.type = NULL,
  annotation = NULL, results = as.integer(100), pagetoken = NULL,
  verbose = getOption("pyMTurkR.verbose", TRUE))
}
\arguments{
\item{assignment}{An optional character string containing an AssignmentId
whose bonuses should be returned. Must specify \code{assignment} xor
\code{hit} xor \code{hit.type} xor \code{annotation}.}

\item{hit}{An optional character string containing a HITId whose bonuses
should be returned. Must specify \code{assignment} xor \code{hit} xor
\code{hit.type} xor \code{annotation}.}

\item{hit.type}{An optional character string containing a HITTypeId (or a
vector of HITTypeIds) whose bonuses should be returned. Must specify
\code{assignment} xor \code{hit} xor \code{hit.type} xor \code{annotation}.}

\item{annotation}{An optional character string specifying the value of the
\code{RequesterAnnotation} field for a batch of HITs. This can be used to
retrieve bonuses for all HITs from a \dQuote{batch} created in the online
Requester User Interface (RUI). To use a batch ID, the batch must be written
in a character string of the form \dQuote{BatchId:78382;}, where
\dQuote{73832} is the batch ID shown in the RUI. Must specify
\code{assignment} xor \code{hit} xor \code{hit.type} xor \code{annotation}.}

\item{results}{An optional character string indicating how many results to
fetch per page. Must be between 1 and 100. Most users can ignore this.}

\item{pagetoken}{An optional character string indicating which page of
search results to start at. Most users can ignore this.}

\item{verbose}{Optionally print the results of the API request to the
standard output. Default is taken from \code{getOption('pyMTurkR.verbose',
TRUE)}.}
}
\value{
A data frame containing the details of each bonus, specifically:
AssignmentId, WorkerId, Amount, Reason, and GrantTime.
}
\description{
Get details of bonuses paid to workers, by HIT, HITType, Assignment,
or Annotation.
}
\details{
Retrieve bonuses previously paid to a specified HIT, HITType, Assignment,
or Annotation.

\code{bonuses()}, \code{getbonuses()}, \code{ListBonusPayments()} and
\code{listbonuspayments()} are aliases.
}
\examples{

\dontrun{
# Get bonuses for a given assignment
GetBonuses(assignment = "26XXH0JPPSI23H54YVG7BKLO82DHNU")

# Get all bonuses for a given HIT
GetBonuses(hit = "2MQB727M0IGF304GJ16S1F4VE3AYDQ")

# Get bonuses from all HITs of a given batch from the RUI
GetBonuses(annotation = "BatchId:78382;")
}

}
\references{
\href{https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html}{API Reference}
}
\seealso{
\code{\link{GrantBonus}}
}
\author{
Tyler Burleigh, Thomas J. Leeper
}
\keyword{Workers}
