% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pxweb_data_comments.R
\name{pxweb_data_comments}
\alias{pxweb_data_comments}
\alias{pxweb_data_comments.pxweb_data}
\title{Construct a \code{pxweb_data_comments} object.}
\usage{
pxweb_data_comments(x)

\method{pxweb_data_comments}{pxweb_data}(x)
}
\arguments{
\item{x}{a \code{pxweb_data} object.}
}
\value{
a \code{pxweb_data_comments} object
}
\description{
An object that contain the comments for a given PXWEB table.
}
\examples{
\dontrun{
url <- "https://api.scb.se/OV0104/v1/doris/en/ssd/BE/BE0101/BE0101A/BefolkningNy"
json_query <- 
  file.path(system.file(package = "pxweb"), "extdata", "examples", "json_query_example.json")
pxd <- pxweb_get(url = url, query = json_query)
pxdcs <- pxweb_data_comments(x = pxd)
pxdc_df <- as.data.frame(pxdcs, stringsAsFactors = TRUE)
}
}
\keyword{internal}
