% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table2.R
\name{px_source}
\alias{px_source}
\alias{px_source.px}
\title{SOURCE}
\usage{
px_source(x, value, validate)

\method{px_source}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string to set the value for all languages or a data frame with columns 'language' and 'value' to set it for specific languages. If 'value' is missing, the current SOURCE is returned. If NULL, SOURCE is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object, a character string, or a data frame.
}
\description{
Inspect or change SOURCE.
}
\examples{
# Set SOURCE for all languages
x1 <-
  px(population_gl) |>
  px_source('Statistics Greenland')

# Print SOURCE
px_source(x1)

# Set SOURCE for individual languages
library(tibble)
x2 <-
  x1 |>
  px_languages(c('en', 'kl')) |>
  px_source(tribble(~language, ~value,
                      'en', 'Statistics Greenland',
                      'kl', 'Naatsorsueqqissaartarfik'))
px_source(x2)

# Remove SOURCE
x3 <- px_source(x2, NULL)
px_source(x3)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A53\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C165\%2C0\%5D}{Statistics Sweden's documentation}
}
