% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRC.R
\name{MRC}
\alias{MRC}
\title{Compute power for Multiple Regression with up to Five Predictors
Example code below for three predictors. Expand as needed for four or five}
\usage{
MRC(
  ry1 = NULL,
  ry2 = NULL,
  ry3 = NULL,
  ry4 = NULL,
  ry5 = NULL,
  r12 = NULL,
  r13 = NULL,
  r14 = NULL,
  r15 = NULL,
  r23 = NULL,
  r24 = NULL,
  r25 = NULL,
  r34 = NULL,
  r35 = NULL,
  r45 = NULL,
  n = NULL,
  alpha = 0.05
)
}
\arguments{
\item{ry1}{Correlation between DV (y) and first predictor (1)}

\item{ry2}{Correlation between DV (y) and second predictor (2)}

\item{ry3}{Correlation between DV (y) and third predictor (3)}

\item{ry4}{Correlation between DV (y) and fourth predictor (4)}

\item{ry5}{Correlation between DV (y) and fifth predictor (5)}

\item{r12}{Correlation between first (1) and second predictor (2)}

\item{r13}{Correlation between first (1) and third predictor (3)}

\item{r14}{Correlation between first (1) and fourth predictor (4)}

\item{r15}{Correlation between first (1) and fifth predictor (5)}

\item{r23}{Correlation between second (2) and third predictor (3)}

\item{r24}{Correlation between second (2) and fourth predictor (4)}

\item{r25}{Correlation between second (2) and fifth predictor (5)}

\item{r34}{Correlation between third (3) and fourth predictor (4)}

\item{r35}{Correlation between third (3) and fifth predictor (5)}

\item{r45}{Correlation between fourth (4) and fifth predictor (5)}

\item{n}{Sample size}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for Multiple Regression with Two to Five Predictors
}
\description{
Compute power for Multiple Regression with up to Five Predictors
Example code below for three predictors. Expand as needed for four or five
}
\examples{
MRC(ry1=.40,ry2=.40, r12=-.15,n=30)
MRC(ry1=.40,ry2=.40,ry3=-.40, r12=-.15, r13=-.60,r23=.25,n=24)

}
