% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_level_disprop_analysis.R
\name{ci_for_ror}
\alias{ci_for_ror}
\title{Confidence intervals for Reporting Odds Ratio}
\usage{
ci_for_ror(a, b, c, d, conf_lvl_probs)
}
\arguments{
\item{a}{Number of reports for the specific drug and event (i.e. the
observed count).}

\item{b}{Number of reports with the drug, without the event}

\item{c}{Number of reports without the drug, with the event}

\item{d}{Number of reports without the drug, without the event}

\item{conf_lvl_probs}{The probabilities of the normal distribution, based on
a passed confidence level (\code{conf_lvl}) in \code{\link{ror}}. If
\code{sgn_lvl = .95} in \code{ror}, quantiles of the normal distribution will
be extracted at \code{sgn_lvl_probs} of 0.025 and 0.975.}
}
\value{
The credibility interval specified by input parameters.
}
\description{
Mainly for use in \code{\link{ror}}. Produces (symmetric,
normality based) confidence bounds for the ROR, for a passed probability.
Called twice in \code{ror} to create confidence intervals.
}
\seealso{
\code{\link{ror}}
}
