\name{PushoverMessage}
\alias{PushoverMessage}
\title{Create a Pushover message}
\usage{
PushoverMessage(message, ...)
}
\arguments{
  \item{message}{The message to be sent (max. 512
  characters)}

  \item{...}{Any additional message parameters (for a list
  of these, see object slots for
  \code{\link{PushoverMessage-class}})}
}
\value{
A PushoverMessage object
}
\description{
The \code{PushoverMessage} function is a constructor that
creates \code{\link{PushoverMessage-class}} objects. These
objects represent a Pushover message and implement all of
the features available in Pushover's API
(\url{https://pushover.net/api}).
\code{\link{PushoverMessage-class}} objects are used to
build queries that are sent to Pushover's servers.
}
\note{
Pushover user/group keys and application tokens are requred
for a message. They can either be specified as arguments or
be set earlier with \code{\link{set_pushover_user}} and
\code{\link{set_pushover_app}}, respectively.
}
\examples{
\dontrun{
library(pushoverr)

# Create a PushoverMessage
m2 <- PushoverMessage(message='Hi there',
                      token='KzGDORePK8gMaC0QOYAMyEEuzJnyUi',
                      user='KAWXTswy4cekx6vZbHBKbCKk1c1fdf')

# If the app token and user key have already been set, messages can be
# created with just the message argument
set_pushover_user('KAWXTswy4cekx6vZbHBKbCKk1c1fdf')
set_pushover_app('KzGDORePK8gMaC0QOYAMyEEuzJnyUi')
m3 <- PushoverMessage(message='so much less work!')
}
}
\seealso{
\code{\link{PushoverMessage-class}}
}

