% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{type-predicates}
\alias{type-predicates}
\alias{is_list}
\alias{is_atomic}
\alias{is_vector}
\alias{is_numeric}
\alias{is_integer}
\alias{is_double}
\alias{is_character}
\alias{is_logical}
\alias{is_null}
\alias{is_function}
\title{Type predicates}
\usage{
is_list(x)

is_atomic(x)

is_vector(x)

is_numeric(x)

is_integer(x)

is_double(x)

is_character(x)

is_logical(x)

is_null(x)

is_function(x)
}
\arguments{
\item{x}{object to be tested.}
}
\description{
These type predicates aim to make type testing in R more
consistent. They are wrappers around \code{\link{typeof}}, so
operate at a level beneath S3/S4 etc.
}
\details{
Compare to base R functions:
\itemize{
  \item Unlike \code{is.atomic()}, \code{is_atomic()} does not
     return \code{TRUE} for \code{NULL}.
  \item Unlike \code{is.vector()}, \code{is_vector()} test if an
        object is an atomic vector or a list. \code{is.vector}
        checks for the presence of attributes (other than name).
  \item \code{is_numeric()} is not generic so, (e.g.) dates and date times
    are \code{TRUE}, not \code{FALSE}.
  \item \code{is_function()} returns \code{TRUE} only for regular
    functions, not special or primitive functions.
}
}
\seealso{
\link{bare-type-predicates} \link{scalar-type-predicates}
}
