% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{accumulate}
\alias{accumulate}
\alias{accumulate_right}
\title{Accumulate recursive folds across a list}
\usage{
accumulate(.x, .f, ..., .init)

accumulate_right(.x, .f, ..., .init)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A two-argument function.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.init}{If supplied, will be used as the first value to start
the accumulation, rather than using \code{x[[1]]}. This is useful if
you want to ensure that \code{reduce} returns the correct value when
\code{.x} is \code{\link{is_empty}()}.}
}
\description{
\code{accumulate} applies a function recursively over a list from the left, while
\code{accumulate_right} applies the function from the right. Unlike \code{reduce}
both functions keep the intermediate results.
}
\examples{
1:3 \%>\% accumulate(`+`)
1:10 \%>\% accumulate_right(`*`)

# From Haskell's scanl documentation
1:10 \%>\% accumulate(max, .init = 5)

# Simulating stochastic processes with drift
\dontrun{
library(dplyr)
library(ggplot2)

rerun(5, rnorm(100)) \%>\%
  set_names(paste0("sim", 1:5)) \%>\%
  map(~ accumulate(., ~ .05 + .x + .y)) \%>\%
  map_df(~ data_frame(value = .x, step = 1:100), .id = "simulation") \%>\%
  ggplot(aes(x = step, y = value)) +
    geom_line(aes(color = simulation)) +
    ggtitle("Simulations of a random walk with drift")
}
}

