% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{F}
\alias{F}
\title{Inbreeding coefficient}
\usage{
F(ped, name_to)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{name_to}{A string naming the new output column.}
}
\value{
The input dataframe, plus an additional column named "F" with individual inbreeding coefficient values.
}
\description{
Computes the standard inbreeding coefficient (\emph{F}).
This is the probability that two alleles on a locus are identical by descent (Falconer and Mackay 1996, Wright 1922), calculated from the genealogical coancestry matrix (Malécot 1948).
}
\references{
\itemize{
  \item{Falconer DS, Mackay TFC. 1996. Introduction to Quantitative Genetics. 4th edition. Longman, Essex, U.K.}
  \item{Malécot G, 1948. Les Mathématiques de l’hérédité. Masson & Cie., Paris.}
  \item{Wright S. 1922. Coefficients of inbreeding and relationship. The American Naturalist 56: 330-338.}
}
}
