% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rename}
\alias{rename}
\title{Rename individuals in a pedigree from 1 to N}
\usage{
rename(ped, id = "id", dam = "dam", sire = "sire", keep_names = FALSE)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{id}{A string naming the column with individual identities. It will be renamed to its default value 'id'.}

\item{dam}{A string naming the column with maternal identities. It will be renamed to its default value 'dam'.}

\item{sire}{A string naming the column with paternal identities. It will be renamed to its default value 'sire'.}

\item{keep_names}{A boolean value indicating whether the original identity values should be kept on a separate column (named 'names'), or not.}
}
\value{
A dataframe with the pedigree's identities renamed.
}
\description{
Functions in \bold{purgeR} require individuals to be named from 1 to N.
This takes a dataframe containing a pedigree, and rename individuals having
names in any format to that required by other functions in \pkg{purgeR}.
}
