% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ne.R
\encoding{UTF-8}
\name{pop_Ne}
\alias{pop_Ne}
\title{Effective population size}
\usage{
pop_Ne(ped, Fcol, tcol)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{Fcol}{Name of column with inbreeding coefficient values.}

\item{tcol}{Name of column with generation numbers.}
}
\value{
A list with the effective population size (Ne) and its standard error (se_Ne).
}
\description{
Estimate the effective population size (\emph{Ne}). This is computed from the increase in individual inbreeding, following the method described by Gutiérrez et al (2008, 2009).
}
\examples{
data(atlas)
atlas <- ip_F(atlas) # compute inbreeding, appending column "F"
atlas <- pop_t(atlas) # compute generations, appending column "t"
pop_Ne(atlas, Fcol = "Fi", tcol = "t")
}
\references{
\itemize{
  \item{Gutiérrez JP, Cervantes I, Molina A, Valera M, Goyache F. 2008. Individual increase in inbreeding allows estimating effective sizes from pedigrees. Genet. Sel. Evol. 40: 359-378.}
  \item{Gutiérrez JP, Cervantes I, Goyache F. 2009. Improving the estimation of realized effective population sizes in farm animals. J. Anim. Breed. Genet. 126: 327-332.}
}
}
\seealso{
\code{\link{ip_F}}, \code{\link{pop_t}}
}
