% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{ip_Fij}
\alias{ip_Fij}
\title{Partial inbreeding coefficient}
\usage{
ip_Fij(ped, mode = "founders", ancestors = NULL, Fcol = NULL, ncores = 1L)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{mode}{Defines the set of ancestors considered when computing partial inbreeding. It can be set as:
"founder" for inbreeding conditional to founders only (default),
"all" for all individuals in the pedigree (it may take long to compute in large pedigrees),
and "custom" for individuals identities given in a integer vector (see 'ancestors' argument).}

\item{ancestors}{Under the "custom" run mode, it defines a vector of ancestors that will be considered
when computing partial inbreeding values.}

\item{Fcol}{Name of column with inbreeding coefficient values. If none is used, inbreeding will be computed.}

\item{ncores}{Number of cores to use for parallel computing (default = 1)}
}
\value{
A matrix of partial inbreeding coefficients. \emph{Fi(j)} values can thus be read from row i and column j.
In the resultant matrix, there are as many rows as individuals in the pedigree, and as many columns as ancestors used.
Columns will be named and sorted by ancestor identity.
}
\description{
Computes partial inbreeding coefficients, \emph{Fi(j)}.
A coefficient \emph{Fi(j)} can be read as the probability of individual \emph{i} being
homozygous for alleles derived from ancestor \emph{j}.
It is calculated following the tabular method described by Gulisija & Crow (2007).
}
\examples{
data(arrui)
# Partial inbreeding relative to founder ancestors
m <- ip_Fij(arrui)
# Note that in the example above, the sum of the values in
# rows will equal the vector of inbreeding coefficients
# i.e. base::rowSums(m) equals purgeR::ip_F(arrui)$F

# Compute partial inbreeding relative to an arbitrary ancestor with id = 6
anc <- as.integer(c(6))
ip_Fij(arrui, mode = "custom", ancestors = anc)
}
\references{
\itemize{
  \item{Gulisija D, Crow JF. 2007. Inferring purging from pedigree data. Evolution 61(5): 1043-1051.}
}
}
\seealso{
\code{\link{ip_F}}
}
