% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inbreeding.R
\name{ip_Fa}
\alias{ip_Fa}
\title{Ancestral inbreeding coefficient}
\usage{
ip_Fa(ped, name_to = "Fa", genedrop = 0, seed = NULL, Fcol = NULL)
}
\arguments{
\item{ped}{A dataframe containing the pedigree. Individual (id), maternal (dam), and paternal (sire) identities are mandatory columns.}

\item{name_to}{A string naming the new output column.}

\item{genedrop}{Number of genedrop iterations to run. If set to zero (as default), Ballou's Fa is computed.}

\item{seed}{Sets a seed for the random number generator.}

\item{Fcol}{Name of column with inbreeding coefficient values. If none is used, inbreeding will be computed.}
}
\value{
The input dataframe, plus an additional column with individual ancestral inbreeding coefficient values (named "Fa" by default).
}
\description{
Computes the ancestral inbreeding coefficient (\emph{Fa}).
This is the probability that an allele has been in homozygosity in at least one ancestor (Ballou 1997).
A genedrop approach is included to compute unbiased estimates of \emph{Fa} (Baumung et al. 2015).
}
\examples{
data(dama)
ip_Fa(dama) # Compute F on the go (won't be kept in the pedigree).
dama <- ip_F(dama)
dama <- ip_Fa(dama, Fcol = 'Fi') # If F is computed in advance.
}
\references{
\itemize{
  \item{Ballou JD. 1997. Ancestral inbreeding only minimally affects inbreeding depression in mammalian populations. J Hered. 88:169–178.}
  \item{Baumung et al. 2015. GRAIN: A computer program to calculate ancestral and partial inbreeding coefficients using a gene dropping approach. Journal of Animal Breeding and Genetics 132: 100-108.}
}
}
\seealso{
\code{\link{ip_F}}, \code{\link{exp_Fa}}
}
