% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_topology_line.R
\name{is_topology_line}
\alias{is_topology_line}
\title{Is the line of text the topology, as used within
a FASTA filename?}
\usage{
is_topology_line(line)
}
\arguments{
\item{line}{line of text from a FASTA filename}
}
\value{
\link{TRUE} if the line can be the text of a topology in a
FASTA file.
}
\description{
Is the line of text the topology, as used within
a FASTA filename? In this context, a topology is a string of zeroes
and ones, in which a one denotes that that amino acid is within
the membrane.
}
\examples{
# This is a valid topology
is_topology_line("000010101011")

# This is an invalid topology
is_topology_line("invalid")
}
\author{
Richèl J.C. Bilderbeek
}
