% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.ks}
\alias{style.apa.ks}
\title{Formats a Kolmogorov-Smirnov-Test}
\usage{
style.apa.ks(x)
}
\arguments{
\item{x}{a list. First item must be a Kolmogorv-Smirnov test (htest class)
from \code{\link[stats]{ks.test}}. All other list items will be ignored.}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes a Kolmogorov-Smirnow test (htest class) from
\code{\link[stats]{ks.test}} and transforms it into a formatted character
vector.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
x <- rnorm(50)
y <- runif(30)

pprint(ks.test(x, y),
       format = "ks")
}
\seealso{
\code{\link[stats]{ks.test}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}},
  \code{\link{style.apa.fisher}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

