% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{xymultiple}
\alias{xymultiple}
\title{Multiple comparisons with plot.}
\usage{
xymultiple(model.glht, method = "bonferroni", Exp = FALSE, dg = 2,
  plot = TRUE, rotx = 45, ...)
}
\arguments{
\item{model.glht}{An object of class "glht" (from multiple comparisons).}

\item{method}{Method passed to \link{summary.glht} (see details).}

\item{Exp}{Logical, should results be exponentiated? (default = FALSE).}

\item{dg}{Number of digits for rounding (default = 2).}

\item{plot}{Logical, should a plot be constructed? (default = TRUE).}

\item{rotx}{Degrees to rotate x-labels (default = 45).}

\item{...}{Passes additional information to \code{xyplot}.}
}
\value{
A data frame with CIs and p-values adjusted for multiple comparisons.
}
\description{
\code{xymultiple} displays results from post-doc analysis and constructs corresponding plot.
}
\details{
The default adjusting method is "bonferroni". Other options are: "single-step", "Shaffer",
"free", "holm", "hochberg", "hommel", "Westfall".
}
\examples{
library(multcomp)
data(birthwt)
birthwt$race <- factor(birthwt$race, labels = c("White", "Black", "Other"))
model1 <- aov(bwt ~ race, data = birthwt)
model1_glht <- glht(model1, linfct = mcp(race = "Tukey"))
xymultiple(model1_glht)

model2 <- glm(low ~ race, data = birthwt, family = binomial)
model2_glht <- glht(model2, linfct = mcp(race="Tukey"))
xymultiple(model2_glht, Exp = TRUE)
}
\seealso{
\code{glht}, \code{glht-methods}.
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
