% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route-types.R
\name{describe_route_type}
\alias{describe_route_type}
\title{Convert a numeric route type to a human-friendly description}
\usage{
describe_route_type(
  route_type,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_type}{Atomic integer or character.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
character
}
\description{
This function effectively wraps the results of \code{\link{route_types}} to
translate a route type to a human-readable form, such as translating \code{0} to
\code{"Train"}. This function is \emph{not} vectorised.
}
\keyword{Internal}
