% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directions.R
\name{directions_on_route}
\alias{directions_on_route}
\title{Directions on a given route}
\usage{
directions_on_route(
  route_id,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{route_id}{Integer. These can be listed and described with the \code{routes}
function.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble consisting of the following columns: \itemize{
\item \code{direction_id}
\item \code{direction_name},
\item \code{route_id}
\item \code{route_type}
\item \code{route_direction_description}
}
}
\description{
Directions on a given route
}
\examples{
\dontrun{
directions_on_route(6)
}
}
