% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_file_nos.R
\name{adj_file_nos}
\alias{adj_file_nos}
\title{Adjust file numbers.}
\usage{
adj_file_nos(target, directory = NULL, action = "up", step = 1)
}
\arguments{
\item{target}{Required. The number in the sequential scripts to begin the
adjustment. The adjustment will affect script with that leading digit and
greater.}

\item{directory}{The directory holding the sequential
scripts.}

\item{action}{Defaults to "up". Whether to adjust file numbers up or down.}

\item{step}{Defaults to 1. The step by which to increment or decrement the
file numbering.}
}
\value{
Renumbers filenames in the specified directory, according to the
specified action. Only affects the target file and above.
}
\description{
This function is used to increment / decrease sequential scripts within the
specified directory, allowing efficient adjustment of script sequence for
additional or removed files.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

seq_file_ops(n = 10, target_dir = "munge")

# Increase files numbered 6 and above by 1
adj_file_nos(target = 6, directory = "munge")

# Increase above target files by a further 2
adj_file_nos(target = 6, directory = "munge", step = 2)

# Use step = "down" to restore original sequence
adj_file_nos(target = 6, directory = "munge", action = "down", step = 3)

# writing books or websites:
seq_file_ops(n = 5, target_dir = "images", filetype = "png")
# adjust by decimals
adj_file_nos(target = 1, directory = "images", step = 0.1)

# tidying up environment
unlink(c("munge", "images"), recursive = TRUE)

\dontshow{setwd(.old_wd)}

}
