% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{B3}
\alias{B3}
\title{Benchmark set B3}
\format{A vector containg 518 genes' names.}
\source{
The raw data can be downloaded from 
\url{http://www.cbs.dtu.dk/cellcycle/yeast_benchmark/benchmark.php}.
}
\usage{
data(B3)
}
\description{
List for yeast genes which are \bold{less} likely to be periodic
(the benchmark set 3 in de Lichtenberg et al. (2005)).
}
\details{
Genes annotated in MIPS (Mewes et al., 2002) as 'cell cycle
and DNA processing'. From these, we removed genes annotated
specifically as 'meiosis' and genes included in B1 (67), leaving
518 genes. As a large number of genes involved in the cell cycle
are not subject to transcriptional regulation (not periodic), and
because B1 was explicitly removed, a relatively small fraction
of these genes should be expected to be periodically expressed.
}
\examples{
data(alpha)
data(B3)
alphaB3 <- alpha[rownames(alpha)  \\\%in\\\% B3,]

}
\references{
De Lichtenberg, U., Jensen, L. J., Fausboll, A., 
Jensen, T. S., Bork, P.,& Brunak, S. (2005). 
Comparison of computational methods for the identification 
of cell cycle-regulated genes. Bioinformatics, 21(7), 1164-1171.
}
\keyword{datasets}

