% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychometrics.R
\name{total_scores}
\alias{total_scores}
\title{Calculate the total scores from sets of scores}
\usage{
total_scores(.data, ..., .method = "mean", .append = FALSE)
}
\arguments{
\item{.data}{A data frame with columns to summed or averaged over.}

\item{...}{A comma separated set of named tidy selectors, each of which selects a set of columns to which to apply the totalling function.}

\item{.method}{The method used to calculate the total. Must be one of "mean",
"sum", or "sum_like". The "mean" is the arithmetic mean, skipping missing
values. The "sum" is the sum, skipping missing values. The "sum_like" is
the arithmetic mean, again skipping missing values, multiplied by the number of elements, including missing values.}

\item{.append}{logical If FALSE, just the totals be returned. If TRUE, the totals are appended as new columns to original data frame.}
}
\value{
A new data frame with columns representing the total scores.
}
\description{
Calculate the total scores from sets of scores
}
\examples{
# Calculate the mean of all items beginning with `x_` and separately all items beginning with `y_`
total_scores(test_psychometrics, x = starts_with('x'), y = starts_with('y'))
# Calculate the sum of all items beginning with `z_` and separately all items beginning with `x_`
total_scores(test_psychometrics, .method = 'sum', z = starts_with('z'), x = starts_with('x_'))
# Calculate the mean of all items from `x_1` to `y_10`
total_scores(test_psychometrics, xy = x_1:y_10)
}
