% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-classes.R, R/aaa-generics.R
\docType{class}
\name{Mlr-class}
\alias{Mlr-class}
\alias{sigma2,Mlr-method}
\alias{sigma2<-,Mlr-method}
\alias{a0,Mlr-method}
\alias{a0<-,Mlr-method}
\alias{b0,Mlr-method}
\alias{b0<-,Mlr-method}
\alias{Mlr}
\title{S4 class for a regression model that inherits from \linkS4class{Model}.}
\usage{
\S4method{sigma2}{Mlr}(x)

\S4method{sigma2}{Mlr}(x) <- value

\S4method{a0}{Mlr}(x)

\S4method{a0}{Mlr}(x) <- value

\S4method{b0}{Mlr}(x)

\S4method{b0}{Mlr}(x) <- value

Mlr(a0 = 0.001, b0 = 0.001, sigma2 = NaN, ...)
}
\arguments{
\item{x}{An \code{Model} object.}

\item{value}{A value to assign to a slot for \code{x}}

\item{a0}{A prior shape hyperparameter for sigma2.}

\item{b0}{A prior rate hyperparameter for sigma2.}

\item{sigma2}{A nchain x 1 numeric vector of draws of the residual variance.}

\item{...}{additional arguments to be passed to the low level regression
fitting functions (see below).}
}
\value{
An \linkS4class{Mlr} object.
}
\description{
S4 class for a regression model that inherits from \linkS4class{Model}.

Helper function (constructor) for \code{Mlr} class
}
\section{Slots}{

\describe{
\item{\code{a0}}{A prior shape hyperparameter for sigma2.}

\item{\code{b0}}{A prior rate hyperparameter for sigma2.}

\item{\code{sigma2}}{A nchain x 1 numeric vector of draws of the residual variance.}
}}

\examples{
m1 <- Mlr(ndocs = 1)
print(m1)

}
\keyword{classes}
