% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTWetBulbFromTDewPoint}
\alias{GetTWetBulbFromTDewPoint}
\title{Return wet-bulb temperature given dry-bulb temperature, dew-point temperature, and pressure.}
\usage{
GetTWetBulbFromTDewPoint(TDryBulb, TDewPoint, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TDewPoint}{A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return wet-bulb temperature given dry-bulb temperature, dew-point temperature, and pressure.
}
\examples{
SetUnitSystem("IP")
GetTWetBulbFromTDewPoint(80:100, 40.0, 14.696)

SetUnitSystem("SI")
GetTWetBulbFromTDewPoint(25:40, 20.0, 101325.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
