% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{CalcPsychrometricsFromTWetBulb}
\alias{CalcPsychrometricsFromTWetBulb}
\title{Calculate psychrometric values from wet-bulb temperature.}
\usage{
CalcPsychrometricsFromTWetBulb(TDryBulb, TWetBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TWetBulb}{A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A list with named components for each psychrometric value computed:
\describe{
  \item{HumRatio}{Humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}
  \item{TDewPoint}{Dew-point temperature in degreeF [IP] or degreeC [SI]}
  \item{RelHum}{Relative humidity in range [0, 1]}
  \item{VapPres}{Partial pressure of water vapor in moist air in Psi [IP] or Pa [SI]}
  \item{MoistAirEnthalpy}{Moist air enthalpy in Btu lb-1 [IP] or J kg-1 [SI]}
  \item{MoistAirVolume}{Specific volume of moist air in ft3 lb-1 [IP] or in m3 kg-1 [SI]}
  \item{DegreeOfSaturation}{Degree of saturation [unitless]}
}
}
\description{
Utility function to calculate humidity ratio, dew-point temperature, relative humidity,
vapour pressure, moist air enthalpy, moist air volume, and degree of saturation of air given
dry-bulb temperature, wet-bulb temperature, and pressure.
}
\examples{
SetUnitSystem("IP")
CalcPsychrometricsFromTWetBulb(80:100, 65.0, 14.696)

SetUnitSystem("SI")
CalcPsychrometricsFromTWetBulb(25:40, 20, 101325.0)

}
