% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_cor.R
\name{bayes_cor}
\alias{bayes_cor}
\title{Bayesian Correlation Matrix.}
\usage{
bayes_cor(df, df2 = NULL, reorder = TRUE)
}
\arguments{
\item{df}{The dataframe.}

\item{df2}{Optional dataframe to correlate with the first one.}

\item{reorder}{Reorder matrix by correlation strength. Only for square matrices.}
}
\value{
A list of dataframes
}
\description{
Bayesian Correlation Matrix.
}
\examples{
\dontrun{
library(psycho)

df <- psycho::affective
cor <- bayes_cor(df)
summary(cor)
print(cor)
plot(cor)

df <- select(psycho::affective, Adjusting, Tolerating)
df2 <- select(psycho::affective, -Adjusting, -Tolerating)
cor <- bayes_cor(df, df2)
summary(cor)
print(cor)
plot(cor)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
