% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad_list.R
\name{create_ad_tibble}
\alias{create_ad_tibble}
\alias{create_ad_list}
\title{Create a tibble of artifact distributions by construct}
\usage{
create_ad_tibble(
  ad_type = c("tsa", "int"),
  n = NULL,
  sample_id = NULL,
  construct_x = NULL,
  facet_x = NULL,
  measure_x = NULL,
  construct_y = NULL,
  facet_y = NULL,
  measure_y = NULL,
  rxx = NULL,
  rxx_restricted = TRUE,
  rxx_type = "alpha",
  k_items_x = NA,
  ryy = NULL,
  ryy_restricted = TRUE,
  ryy_type = "alpha",
  k_items_y = NA,
  ux = NULL,
  ux_observed = TRUE,
  uy = NULL,
  uy_observed = TRUE,
  estimate_rxxa = TRUE,
  estimate_rxxi = TRUE,
  estimate_ux = TRUE,
  estimate_ut = TRUE,
  moderators = NULL,
  cat_moderators = TRUE,
  moderator_type = c("simple", "hierarchical", "none"),
  construct_order = NULL,
  supplemental_ads = NULL,
  data = NULL,
  control = control_psychmeta(),
  ...
)

create_ad_list(
  ad_type = c("tsa", "int"),
  n = NULL,
  sample_id = NULL,
  construct_x = NULL,
  facet_x = NULL,
  measure_x = NULL,
  construct_y = NULL,
  facet_y = NULL,
  measure_y = NULL,
  rxx = NULL,
  rxx_restricted = TRUE,
  rxx_type = "alpha",
  k_items_x = NA,
  ryy = NULL,
  ryy_restricted = TRUE,
  ryy_type = "alpha",
  k_items_y = NA,
  ux = NULL,
  ux_observed = TRUE,
  uy = NULL,
  uy_observed = TRUE,
  estimate_rxxa = TRUE,
  estimate_rxxi = TRUE,
  estimate_ux = TRUE,
  estimate_ut = TRUE,
  moderators = NULL,
  cat_moderators = TRUE,
  moderator_type = c("simple", "hierarchical", "none"),
  construct_order = NULL,
  supplemental_ads = NULL,
  data = NULL,
  control = control_psychmeta(),
  ...
)
}
\arguments{
\item{ad_type}{Type of artifact distributions to be computed: Either "tsa" for Taylor series approximation or "int" for interactive.}

\item{n}{Vector or column name of sample sizes.}

\item{sample_id}{Optional vector of identification labels for samples/studies in the meta-analysis.}

\item{construct_x, construct_y}{Vector of construct names for constructs initially designated as "X" or "Y".}

\item{facet_x, facet_y}{Vector of facet names for constructs initially designated as "X" or "Y".
Facet names "global", "overall", and "total" are reserved to indicate observations that represent effect sizes that have already been composited or that represent construct-level measurements rather than facet-level measurements.
To avoid double-compositing, any observation with one of these reserved names will only be eligible for auto-compositing with other such observations and will not be combined with narrow facets.}

\item{measure_x, measure_y}{Vector of names for measures associated with constructs initially designated as "X" or "Y".}

\item{rxx}{Vector or column name of reliability estimates for X.}

\item{rxx_restricted}{Logical vector or column name determining whether each element of rxx is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{rxx_type, ryy_type}{String vector identifying the types of reliability estimates supplied. See documentation of \code{\link{ma_r}} for a full list of acceptable values.}

\item{k_items_x, k_items_y}{Numeric vector identifying the number of items in each scale.}

\item{ryy}{Vector or column name of reliability estimates for Y.}

\item{ryy_restricted}{Logical vector or column name determining whether each element of ryy is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{ux}{Vector or column name of u ratios for X.}

\item{ux_observed}{Logical vector or column name determining whether each element of ux is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{uy}{Vector or column name of u ratios for Y.}

\item{uy_observed}{Logical vector or column name determining whether each element of uy is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{estimate_rxxa}{Logical argument to estimate rxxa values from other artifacts (\code{TRUE}) or to only used supplied rxxa values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_rxxi}{Logical argument to estimate rxxi values from other artifacts (\code{TRUE}) or to only used supplied rxxi values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_ux}{Logical argument to estimate ux values from other artifacts (\code{TRUE}) or to only used supplied ux values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_ut}{Logical argument to estimate ut values from other artifacts (\code{TRUE}) or to only used supplied ut values (\code{FALSE}). \code{TRUE} by default.}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{cat_moderators}{Logical scalar or vector identifying whether variables in the \code{moderators} argument are categorical variables (\code{TRUE}) or continuous variables (\code{FALSE}).}

\item{moderator_type}{Type of moderator analysis: "none" means that no moderators are to be used, "simple" means that moderators are to be examined one at a time, and
"hierarchical" means that all possible combinations and subsets of moderators are to be examined.}

\item{construct_order}{Vector indicating the order in which variables should be arranged, with variables listed earlier in the vector being preferred for designation as X.}

\item{supplemental_ads}{Named list (named according to the constructs included in the meta-analysis) of supplemental artifact distribution information from studies not included in the meta-analysis. This is a list of lists, where the elements of a list associated with a construct are named like the arguments of the \code{create_ad()} function.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments.}

\item{control}{Output from the \code{control_psychmeta()} function or a list of arguments controlled by the \code{control_psychmeta()} function. Ellipsis arguments will be screened for internal inclusion in \code{control}.}

\item{...}{Additional arguments}
}
\value{
A tibble of artifact distributions
}
\description{
Create a tibble of artifact distributions by construct
}
\examples{
## Examples to create Taylor series artifact distributions:
# Overall artifact distributions (not pairwise, not moderated)
create_ad_tibble(ad_type = "tsa",
                 n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 sample_id = sample_id, moderators = moderator,
                 data = data_r_meas_multi,
                 control = control_psychmeta(pairwise_ads = FALSE,
                                             moderated_ads = FALSE))

# Overall artifact distributions by moderator combination
create_ad_tibble(ad_type = "tsa",
                 n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 sample_id = sample_id, moderators = moderator,
                 data = data_r_meas_multi,
                 control = control_psychmeta(pairwise_ads = FALSE,
                                             moderated_ads = TRUE))

# Pairwise artifact distributions (not moderated)
create_ad_tibble(ad_type = "tsa",
                 n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 sample_id = sample_id, moderators = moderator,
                 data = data_r_meas_multi,
                 control = control_psychmeta(pairwise_ads = TRUE,
                                               moderated_ads = FALSE))

# Pairwise artifact distributions by moderator combination
create_ad_tibble(ad_type = "tsa",
                 n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 sample_id = sample_id, moderators = moderator,
                 data = data_r_meas_multi,
                 control = control_psychmeta(pairwise_ads = TRUE,
                                             moderated_ads = TRUE))
}
