% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\encoding{UTF-8}
\name{format_num}
\alias{format_num}
\title{Format numbers for presentation}
\usage{
format_num(x, digits = 2L, decimal.mark = getOption("OutDec"),
  leading0 = "conditional", drop0integer = FALSE, neg.sign = "minus",
  pos.sign = "figure", big.mark = "thinspace", big.interval = 3L,
  small.mark = "thinspace", small.interval = 3L)
}
\arguments{
\item{x}{A vector, matrix, or data.frame of numbers to format}

\item{digits}{The number of decimal digits desired (used strictly; default: 2)}

\item{decimal.mark}{The character to use for the decimal point (defaults to locale default: \code{getOption("OutDec")})}

\item{leading0}{How to print leading zeros on decimals. Can be logical to print (\code{TRUE}) or suppress (\code{FALSE}) leading zeros or a character string to subsitute for leading zeros. If \code{"conditional"} (default), leading zeros are shown if a column contains any absolute values greater than 1 and suppressed otherwise. If \code{"figure"}, leading zeros are replaced with a figure space (\code{U+2007}: "<U+2007>") if a column contains any absolute values greater than 1 and suppressed otherwise.}

\item{drop0integer}{Logical. Should trailing decimal zeros be dropped for integers?}

\item{neg.sign}{Character to use as negative sign. Defaults to minus-sign (\code{U+2212}: "<U+2212>").}

\item{pos.sign}{Character to use as positive sign. Set to \code{FALSE} to suppress. If \code{"figure"} (default), the positive sign is a figure-space (\code{U+2007}: "<U+2007>") if a column contains any negative numbers and suppressed otherwise.}

\item{big.mark}{Character to mark between each \code{big.interval} digits \emph{before} the decimal point. Set to \code{FALSE} to suppress. Defaults to the SI/ISO 31-0 standard-recommened thin-spaces (\code{U+202F}: "<U+202F>").}

\item{big.interval}{See \code{big.mark} above; defaults to 3.}

\item{small.mark}{Character to mark between each \code{small.interval} digits \emph{after} the decimal point. Set to \code{FALSE} to suppress. Defaults to the SI/ISO 31-0 standard-recommened thin-spaces (\code{U+202F}: "<U+202F>").}

\item{small.interval}{See \code{small.mark} above; defaults to 3.}
}
\description{
A function to format decimal digits, leading zeros, and sign characters.
}
\examples{
# format_num() converts numeric values to characters with the specified formatting options.
# By default, thousands digit groups are separated by thin spaces, negative signs are replaced
# with minus signs, and positive signs and leading zeros are replaced with figure spaces
# (which have the same width as numbers and minus signs). These options ensure that all
# results will align neatly in columns when tabled.
format_num(x = c(10000, 1000, 2.41, -1.20, 0.41, -0.20))

# By default, format_num() uses your computer locale's default decimal mark as
# the decimal point. To force the usage of "." instead (e.g., for submission to
# a U.S. journal), set decimal.mark = ".":
format_num(x = .41, decimal.mark = ".")

# By default, format_num() separates groups of large digits using thin spaces.
# This is following the international standard for scientific communication (SI/ISO 31-0),
# which advises against using "." or "," to seprate digits because doing so can lead
# to confusion for human and computer readers because "." and "," are also used
# as decimal marks in various countries. If you prefer to use commmas to separate
# large digit groups, set big.mark = ",":
format_num(x = 10000, big.mark = ",")
}
