% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabulate.R
\name{metabulate}
\alias{metabulate}
\title{Write a summary table of meta-anlytic results}
\usage{
metabulate(ma_obj, path, show_conf = TRUE, show_cred = TRUE,
  show_se = FALSE)
}
\arguments{
\item{ma_obj}{Meta-analysis object.}

\item{path}{Path (with file name and .rtf extension) for the ouput file.}

\item{show_conf}{Logical scalar determining whether to show confidence intervals (\code{TRUE}; default) or not (\code{FALSE}).}

\item{show_cred}{Logical scalar determining whether to show credibility intervals (\code{TRUE}; default) or not (\code{FALSE}).}

\item{show_se}{Logical scalar determining whether to show standard errors (\code{TRUE}) or not (\code{FALSE}; default).}
}
\value{
Saved rich text file containing tables of meta-analytic output.
}
\description{
Write a summary table of meta-anlytic results
}
\examples{
\dontrun{
## Create output table for meta-analysis of correlations
ma_r_obj <- ma_r(ma_method = "ic", rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi,
                 construct_x = x_name, construct_y = y_name,
                 moderators = moderator, data = data_r_meas_multi)
ma_r_obj <- ma_r_ad(ma_obj = ma_r_obj, correct_rr_x = FALSE, correct_rr_y = FALSE)
metabulate(ma_obj = ma_r_obj, path = "meta tables correlations.rtf")

## Create output table for meta-analysis of d values
ma_d_obj <- ma_d(ma_method = "ic", d = d, n1 = n1, n2 = n2, ryy = ryyi,
                 construct_y = construct, data = data_d_meas_multi)
ma_d_obj <- ma_d_ad(ma_obj = ma_d_obj, correct_rr_g = FALSE, correct_rr_y = FALSE)
metabulate(ma_obj = ma_d_obj, path = "meta tables d values.rtf")

## Create output table for meta-analysis of generic effect sizes
dat <- data.frame(es = data_r_meas_multi$rxyi,
                  n = data_r_meas_multi$n,
                  var_e = (1 - data_r_meas_multi$rxyi^2)^2 / (data_r_meas_multi$n - 1))
ma_obj <- ma_generic(es = es, n = n, var_e = var_e, data = dat)
metabulate(ma_obj = ma_obj, path = "meta tables generic es.rtf")
}
}
