% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r_order2.R
\name{ma_r_order2}
\alias{ma_r_order2}
\title{Second-order meta-analysis function for correlations}
\usage{
ma_r_order2(r = NULL, rho = NULL, var_r = NULL, var_r_c = NULL,
  k = NULL, ma_type = c("bb", "ic", "ad"), sample_id = NULL,
  moderators = NULL, moderator_type = "simple", construct_x = NULL,
  construct_y = NULL, conf_level = 0.95, cred_level = 0.8,
  conf_method = "t", cred_method = "t", var_unbiased = TRUE,
  hs_override = FALSE, data = NULL)
}
\arguments{
\item{r}{Vector or column name of mean observed correlations.}

\item{rho}{Vector or column name of mean corrected correlations.}

\item{var_r}{Vector or column name of observed variances of observed correlations.}

\item{var_r_c}{Vector or column name of observed variances of corrected correlations.}

\item{k}{Vector or column name of meta-analyses' k values.}

\item{ma_type}{Type of meta-analyses being analyzed: "bb" (barebones), "ic" (individual correction), or "ad" (artifact distribution).}

\item{sample_id}{Vector or column name of study ID labels.}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{moderator_type}{Type of moderator analysis ("none", "simple", or "hierarchical").}

\item{construct_x}{Vector or column name of construct names for X.}

\item{construct_y}{Vector or column name of construct names for Y.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{cred_level}{Credibility level to define the width of the credibility interval (default = .80).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{var_unbiased}{Logical scalar determining whether variances should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{hs_override}{When \code{TRUE}, this will override settings for \code{conf_method} (will set to "norm"), \code{cred_method} (will set to "norm"), and \code{var_unbiased} (will set to \code{FALSE}).}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}
}
\value{
An object of the classes \code{psychmeta}, \code{ma_r_as_r}, \code{ma_order2}, and \code{ma_bb}, \code{ma_ic}, and/or \code{ma_ad}.
}
\description{
This function computes second-order meta-analysis function for correlations. It supports second-order analyses of bare-bones, artifact-distribution, and individual-correction meta-analyses.
}
\examples{
## Analysis of the validity of conscientiousness as a predictor of job performance in East Asia
ma_r_order2(r = r_bar_i, rho = rho_bar_i, var_r = var_r,
            var_r_c = NULL, k = k, ma_type = "ad",
            sample_id = NULL, moderators = NULL,
            construct_x = NULL, construct_y = NULL,
            conf_level = .95, cred_level = .8,
            cred_method = "t", var_unbiased = TRUE,
            data = dplyr::filter(data_r_oh_2009, Predictor == "Conscientiousness"))

## Analysis of the validity of the Big Five traits as predictors of job performance in East Asia
ma_r_order2(r = r_bar_i, rho = rho_bar_i, var_r = var_r,
            var_r_c = NULL, k = k, ma_type = "ad",
            sample_id = NULL, moderators = NULL, construct_x = Predictor,
            conf_level = .95, cred_level = .8,
            cred_method = "t", var_unbiased = TRUE,
            data = data_r_oh_2009)

## Analysis of the average validity of the Big Five traits as predictors of
## job performance by Eastern Asian country
ma_r_order2(r = r_bar_i, rho = rho_bar_i, var_r = var_r,
            var_r_c = NULL, k = k, ma_type = "ad",
            sample_id = NULL, moderators = Country,
            conf_level = .95, cred_level = .8, cred_method = "t",
            var_unbiased = TRUE, data = data_r_oh_2009)
}
