% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error_tsa.R
\name{var_error_r_bvdrr}
\alias{var_error_r_bvdrr}
\title{Taylor series approximation of the sampling variance of correlations corrected using the Case V correction for indirect range restriction}
\usage{
var_error_r_bvdrr(rxyi, var_e, n, ux, uy, qx, qx_restricted = TRUE, qy,
  qy_restricted = TRUE, r_deriv_only = FALSE)
}
\arguments{
\item{rxyi}{Vector of observed correlations.}

\item{var_e}{Vector of estimated sampling variances for rxyi values.}

\item{n}{Vector of sample sizes.}

\item{ux}{Vector of observed-score u ratios for X.}

\item{uy}{Vector of observed-score u ratios for Y.}

\item{qx}{Vector of square roots of reliability estimates for X.}

\item{qx_restricted}{Logical vector determining whether each element of qx is derived from an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{qy}{Vector of square roots of reliability estimates for X.}

\item{qy_restricted}{Logical vector determining whether each element of qy is derived from an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{r_deriv_only}{Logical scalar determining whether to use the partial derivative with respect to rxyi only (\code{TRUE}) or a full Taylor series approximation of the disattenuation formula (\code{FALSE}).}
}
\value{
A vector of corrected correlations' sampling-error variances.
}
\description{
This function propagates error in the bivariate direct range-restriction correction forumula to allow for the computation of a pseudo compound attenutation factor in individual-correction meta-analysis.
Traditional methods for estimating compound attenuation factors (i.e., dividing the observed correlation by the corrected correlation) do not work with the BVDRR correction because BVDRR has an additive term that makes the corrected correlation inappropriate for use in estimating the effect of the correction on the variance of the sampling distribution of correlations.
}
\details{
Per the principles of propagation of uncertainty and assuming that \eqn{q_{X_{a}}}{qxa}, \eqn{q_{Y_{a}}}{qya}, \eqn{u_{X}}{ux}, \eqn{u_{Y}}{uy}, and \eqn{\rho_{XY_{i}}}{rxyi}, are independent, we can derive a linear approximation of the sampling error of \eqn{\rho_{TP_{a}}}{rtpa}. We begin with the bivariate direct range restriction formula,

\deqn{\rho_{TP_{a}}=\frac{\frac{\rho_{XY_{i}}^{2}-1}{2\rho_{XY_{i}}}u_{X}u_{Y}+sign\left(\rho_{XY_{i}}\right)\sqrt{\frac{\left(1-\rho_{XY_{i}}^{2}\right)^{2}}{4\rho_{XY_{i}}}u_{X}^{2}u_{Y}^{2}+1}}{q_{X_{a}}q_{Y_{a}}}}{rtpa}

which can be expressed as

\deqn{\rho_{TP_{a}}=\frac{A+sign\left(\rho_{XY_{i}}\right)B}{q_{X_{a}}q_{Y_{a}}}}{rtpa = (A + sign(rxyi) * B) / (qxa * qya)}

where

\deqn{A=\frac{\rho_{XY_{i}}^{2}-1}{2\rho_{XY_{i}}}u_{X}u_{Y}}{A = (rxyi^2 - 1) / (2 * rxyi) * ux * uy}

and

\deqn{B=\sqrt{\frac{\left(1-\rho_{XY_{i}}^{2}\right)^{2}}{4\rho_{XY_{i}}}u_{X}^{2}u_{Y}^{2}+1}}{B = sqrt((1 - rxyi^2)^2 / (4 * rxyi^2) * ux^2 * uy^2 + 1)}

which implies the following linear approximation of the sampling variance of \eqn{\rho_{TP_{a}}}{rtpa}:

\deqn{SE_{\rho_{TP_{a}}}^{2}=b_{1}^{2}SE_{q_{X_{a}}}^{2}+b_{2}^{2}SE_{q_{Y_{a}}}^{2}+b_{3}^{2}SE_{u_{X}}^{2}+b_{4}^{2}SE_{u_{Y}}^{2}+b_{5}^{2}SE_{\rho_{XY_{i}}}^{2}}{var_rtpa ~= b1^2 * var_qxa + b2^2 * var_qya + b3^2 * var_ux + b4^2 * var_uy + b5^2 * var_rxyi}

where \eqn{b_{1}}{b1}, \eqn{b_{2}}{b2}, \eqn{b_{3}}{b3}, \eqn{b_{4}}{b4}, and \eqn{b_{5}}{b5} are the first-order partial derivatives of the disattenuation formula with respect to \eqn{q_{X_{a}}}{qxa}, \eqn{q_{Y_{a}}}{qya}, \eqn{u_{X}}{ux}, \eqn{u_{Y}}{uy}, and \eqn{\rho_{XY_{i}}}{rxyi}, respectively. These partial derivatives are computed as follows:

\deqn{b_{1}=\frac{\partial\rho_{TP_{a}}}{\partial q_{X_{a}}}=-\frac{\rho_{TP_{a}}}{q_{X_{a}}}}{b1 = -rtpa / qxa}
\deqn{b_{2}=\frac{\partial\rho_{TP_{a}}}{\partial q_{Y_{a}}}=-\frac{\rho_{TP_{a}}}{q_{Y_{a}}}}{b2 = -rtpa / qya}
\deqn{b_{3}=\frac{\partial\rho_{TP_{a}}}{\partial u_{X}}=\frac{\frac{A}{u_{X}}+\frac{\left(1-\rho_{XY_{i}}^{2}\right)^{2}u_{X}u_{Y}^{2}sign\left(\rho_{XY_{i}}\right)}{4\rho_{XY_{i}}^{2}B}}{q_{X_{a}}q_{Y_{a}}}}{b3 = ((A / ux) + ((1 - rxyi^2)^2 * ux * uy^2 * sign(rxyi)) / (4 * rxyi^2 * B)) / (qxa * qya) }
\deqn{b_{4}=\frac{\partial\rho_{TP_{a}}}{\partial u_{Y}}=\frac{\frac{A}{u_{Y}}+\frac{\left(1-\rho_{XY_{i}}^{2}\right)^{2}u_{X}^{2}u_{Y}sign\left(\rho_{XY_{i}}\right)}{4\rho_{XY_{i}}^{2}B}}{q_{X_{a}}q_{Y_{a}}}}{b4 = ((A / uy) + ((1 - rxyi^2)^2 * ux^2 * uy * sign(rxyi)) / (4 * rxyi^2 * B)) / (qxa * qya)}
\deqn{b_{5}=\frac{\partial\rho_{TP_{a}}}{\partial\rho_{XY_{i}}}=\frac{-\frac{A}{\rho_{XY_{i}}}+\frac{sign\left(\rho_{XY_{i}}\right)\left(-\frac{\left(1-\rho_{XY_{i}}^{2}\right)u_{X}^{2}u_{Y}^{2}}{\rho_{XY_{i}}}-\frac{\left(1-\rho_{XY_{i}}^{2}\right)^{2}u_{X}^{2}u_{Y}^{2}}{2\rho_{XY_{i}}^{3}}\right)}{2B}+u_{X}u_{Y}}{q_{X_{a}}q_{Y_{a}}}}{b5 = (-(A / rxyi) + (sign(rxyi) * (-((1 - rxyi^2) * ux^2 * uy^2) / rxyi - ((1 - rxyi^2)^2 * ux^2 * uy^2) / (2 * rxyi^3))) / (2 * B) + (ux * uy)) / (qxa * qya)}
}
\examples{
var_error_r_bvdrr(rxyi = .3, var_e = var_error_r(r = .3, n = 100), n = 100,
                ux = .8, uy = .8,
                qx = .9, qx_restricted = TRUE,
                qy = .9, qy_restricted = TRUE)
}
\references{
Dahlke, J. A., & Wiernik, B. M. (2017).
\emph{One of these artifacts is not like the others: New methods to account for the unique implications of indirect range-restriction corrections in organizational research}.
Unpublished manuscript.
}
