% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{aovSphericityAdjustment}
\alias{aovSphericityAdjustment}
\title{aovSphericityAdjustment}
\usage{
aovSphericityAdjustment(aovObj, type = "GG", adjDF = TRUE)
}
\arguments{
\item{aovObj}{The returned object from a call to ezANOVA}

\item{type}{"GG" (Greenhouse-Geisser) or "HF" (Huynh-Feldt)}

\item{adjDF}{TRUE/FALSE Should DF's be adjusted?}
}
\value{
list
}
\description{
Adjust ezANOVA table with corrections for sphericity (Greenhouse-Geisser or
Huynh-Feldt). Called by default within aovTable
}
\examples{
# Example 1:
# create dataframe with 3(Comp: neutral vs. comp vs. incomp) factors/levels
dat <- createDF(nVP = 20, nTrl = 1,
                design = list("Comp" = c("neutral", "comp", "incomp")))

dat <- addDataDF(dat,
                 RT = list("Comp_neutral" = c(510, 150, 100),
                           "Comp_comp"    = c(500, 150, 100),
                           "Comp_incomp"  = c(520, 150, 100)))

# using ezANOVA
library(ez)
aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp),
                 return_aov = TRUE, detailed = TRUE)
aovDispTable(aovRT)
aovRT <- aovSphericityAdjustment(aovRT)
aovDispTable(aovRT)

}
