% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectsizeValueString.R
\name{effectsizeValueString}
\alias{effectsizeValueString}
\title{effectsizeValueString}
\usage{
effectsizeValueString(ezObj, effect, effectSize = "pes")
}
\arguments{
\item{ezObj}{The returned object from a call to ezANOVA}

\item{effect}{The effect within the ANOVA table to return}

\item{effectSize}{The effect size to report ("ges" default witin ezANOVA, "pes" partial eta squared)}
}
\value{
character
}
\description{
Returns required Latex formatted string for effect size (eta squared, partial
eta square, generalized eta squared) = XXX for R/Sweave integration.
}
\examples{
requiredPackages(c("dplyr", "ez"))
# Example 1:
# create dataframe and add data with 2(Comp: comp vs. incomp) and 2(Side: left vs. right)
dat <- createDF(nVP = 20,
                nTrl = 50,
                design = list("Comp" = c("comp", "incomp"),
                              "Side" = c("left", "right")))

dat <- addDataDF(dat, RT = list(list(c("Comp:comp", "Side:left"), vals = c(500, 150, 100)),
                                list(c("Comp:comp", "Side:right"), vals = c(500, 150, 100)),
                                list(c("Comp:incomp", "Side:left"), vals = c(520, 150, 100)),
                                list(c("Comp:incomp", "Side:right"), vals = c(520, 150, 100))))

# aggregate dat across trials
datAggVP <- dat \%>\%
    group_by(VP, Comp, Side) \%>\%
    summarize(N  = n(),
              rt = mean(RT))

# repeated measures ANOVA using ezANOVA
aovRT <- ezANOVA(datAggVP, dv=.(rt), wid = .(VP), within = .(Comp, Side),
                 return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)

pesString <- effectsizeValueString(aovRT, "Comp")  # partial eta squared
pesString <- effectsizeValueString(aovRT, "Comp:Side")

\dontrun{
# Example use in *.Rnw Sweave file
# \\Sexpr{pesString}}

}
