% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{rrPlot}
\alias{rrPlot}
\title{Residual-Residual Plot}
\usage{
rrPlot(
  formula,
  xlabels = NULL,
  ylab = NULL,
  data,
  return = c("grid", "grobs"),
  ptsize = 1,
  ptshape = 1,
  ptcol = "gray65"
)
}
\arguments{
\item{formula}{Formula giving the variables to be plotted.}

\item{xlabels}{Vector of character strings giving the labs of
variables to be used in place of the variable names.}

\item{ylab}{Character string giving y-variable label to be
used instead of variable name.}

\item{data}{A data frame that holds the variables to be plotted.}

\item{return}{A string identify what to return.  If \sQuote{grid}, 
then a \code{cowplot} object is returned with all plots printed.  
If \sQuote{grobs} then a list with all of the individual ggplots/grobs
is returned.}

\item{ptsize}{Size of points.}

\item{ptshape}{Shape of points.}

\item{ptcol}{Color of points.}
}
\value{
A \code{cowplot} object.
}
\description{
Produces a linear scatterplot array with marginal histograms.
The plots have OLS regression lines and a 45-degree line.
}
\examples{
data(wvs)
library(MASS)
lmod <- lm(secpay ~ gini_disp + democrat + log(pop), data=wvs)
e1_m <- rlm(secpay ~ gini_disp + democrat + log(pop), 
                  data=wvs, method="M")$residuals
e1_mm <- rlm(secpay ~ gini_disp + democrat + log(pop), 
                   data=wvs, method="MM")$residuals
e1dat <- data.frame(OLS = lmod$residuals, 
                    M = e1_m, 
                    MM = e1_mm)
rrPlot(OLS ~ M + MM, data=e1dat)
}
