% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.r
\docType{data}
\name{india}
\alias{india}
\title{Indian Election Data}
\format{
A data frame with 1530 rows and 22 variables
\describe{
\item{patriotism}{Additive scale of level of agreement regarding statements
about patriotism (5-point scale Agree Strongly to Disagree Strongly): Strengthens
India's place in the world (-), leads to intolerance in India (+), is needed for
India to remain united (-), leads to negative attitudes toward immigrants in India (+).
All items are standardized before being summed.}
\item{imp_roots}{Additive scale of level of agreement regarding statements
about importance of the following things for being truly Indian (5-point scale Agree Strongly to Disagree Strongly,
all indicators positively associated with the scale): being born in India, having Indian citizenship,
having lived in India most of your life, ability to speak Hindi, to be Hindu, to respect India's political institutions
and laws, to feel Indian and to have Indian ancestry. All items are standardized and reversed before being summed.}
\item{pride_country}{Additive scale of level of agreement regarding statements
about pride in the following things about India  (5-point scale Agree Strongly to Disagree Strongly,
all indicators positively associated with the scale): the way
democracy works, India's political influence in the world,
India's economic achievements, its social security system,
its scientific and technological achievements, its achievements in sports,
its achievements in the arts and literature, India's armed forces,
its history, its fair and equal treatment of all groups in society.
All items are standardized and reversed before being summed.}
\item{country_first}{Additive scale of level of agreement regarding statements
about the following things regarding India relationships with other countries
(5-point scale Agree Strongly to Disagree Strongly, all indicators positively associated with the scale):
India should limit the import of foreign products to protect national economy,
India should follow its own interests even if that leads to conflict,
foreigners should not be allowed to buy land in India, India's television should give
preference to Indian films and programs. All items are standardized and reversed before being summed.}
\item{anti_immigration}{Additive scale of level of agreement regarding statements
about pride in the following things about immigrants (5-point scale Agree Strongly to Disagree Strongly):
immigrants increase crime dates (+), immigrants are generally good for India's economy (-),
immigrants take jobs away from people born in India (+),
immigrations improve Ind'a s society by bringing new ideas and cultures (-),
India's culture is generally undermined by immigrants (-),
legal immigrants to India who are not citizens should not have the same rights as Indian citizens (+),
India should take stronger measures to exclude illegal immigrants (+),
legal immigrants should have equal access to public education as Indian citizens (-).
All items standardized before being summed.}
\item{educyrs}{Years of formal education, capped at 20.}
\item{age}{Respondent age.}
\item{sbc}{Dummy indicator for Scheduled or Backaward Caste.}
\item{sex}{Binary indicator of respondent gender.}
\item{partliv}{Living in a steady relationship with a partner.}
\item{religgrp}{Religious group to which respondent belongs.}
\item{attend}{Frequency of attendance at religious services.}
\item{topbot}{Self-placement in socio-economic status decile.}
\item{in_ethn1}{Respondent ethnicity.}
\item{hhchildr}{Number of children under 18 in the household.}
\item{in_inc}{Income group in local currency.}
\item{urbrural}{Urban-rural category of residence.}
\item{work}{Ever had paying work (currently, previously, never).}
\item{mainstat}{Main current employment status.}
\item{union}{Union membership (current, previous, never).}
\item{vote_bjp}{Vote for the BJP in most recent election. }
\item{vote_le}{Vote turnout in last election.}
\item{in_prty}{Party voted for in most recent parliamentary election.}
\item{party_lr}{Party voted for in most recent parliamentary election in terms of ideological position.}
}
}
\description{
These data are from the International Social Survey Programme:
National Identity III survey (ISSP Research Group 2015).  This
subset contains only the data from India.
}
\references{
ISSP Research Group (2015): International Social Survey Programme: National Identity III - ISSP 2013. GESIS Data Archive, Cologne. ZA5950 Data file Version 2.0.0, \doi{https://doi.org/10.4232/1.12312}
}
\keyword{datasets}
