% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.r
\docType{data}
\name{ces}
\alias{ces}
\title{Canadian Election Study}
\format{
A data frame with 2799 rows and 29 variables
\describe{
\item{vote}{Vote for Parliament - This variable is used to make
all of the “Vote for …” variables. These are actual self-reported
votes from the post-election study, not campaign-period vote intention.
We coded those who indicated did not vote, none, don't know and refused as missing.}
\item{gender}{Binary variable indicating respondent sex.}
\item{agegrp}{Age Group -  Age is calculated by subtracting the year of birth
from the survey year. Then observations are put into age-groups (18-34, 35-54, 55+)}
\item{relig}{Religious Affiliation - Respondents are coded into four groups -
no religious affiliation/Agnostic, Catholic, Non-Catholic Christians (
incl. Anglican, Baptist, Eastern Orthodox, Johova's Witness, Lutheran, Pentecostal,
Presbyterian, Protestant, United Church of Canada, Christian, Salvatian Army, Mennonite)
and Other (incl. Buddhist, Hindu, Hewish, Muslim, Sikh). We also include an indicator
 variable for Catholic vs non-Catholic.}
\item{educ}{Educational Attainment coded into three categories HS or Less
(incl. No schooling, some elementary, completed elementary, some secondary,
completed secondary), Some Post-secondary (incl. some  echnical/community college,
completed technical/community college, some university) and Univ Grad
(incl. bachelor’s degree, master’s degree, professional degree)}
\item{region}{Provinces are coded into four regions:
Atlantic (Newfoundland and Labrador, PEI, Nova Scotia, New Brunswick),
Quebec, Ontario and the West (Manitoba, Saskatchewan, Alberta and British Columbia)}
\item{province}{Province of respondent}
\item{pid}{Party with which respondent identifies. These are coded into
Liberal, Conservative, NDP, Green, Bloc Quebecois and Other.}
\item{retroper}{Retrospective Personal Economic Perceptions - Whether respondent thinks
his or her personal economic situation has gotten better, stayed the same or gotten worse
in the past year.}
\item{retrocan}{Retrospective National Economic Perceptions - Whether respondent thinks
Canada's economic situation has gotten better, stayed the same or gotten worse in the past year.}
\item{sp_defence}{Respondent's opinion of how much defence spending should change in
three categories - Less (much less, less), Stay the same, More (more or much more).}
\item{sp_envir}{Respondent's opinion of how much spending on the environment should
change in three categories - Less (much less, less), Stay the same, More (more or much more).}
\item{immig}{Respondent's opinion about how immigration levels should change -
Increase, Stay the same/Don't Know, Decrease}
\item{usties}{Respondent's opinion about how ties between Canada and the US should change -
Much more distant, Somewhat more distant, Stay the Same/Don't Know, Somewhat closer, Much closer.}
\item{jobspriv}{Level of agreement with the following statement - The government should leave
it ENTIRELY to the private sector to create jobs: Strongly disagree, Disagree,
Don't know, Agree, Strongly agree.}
\item{blame}{Level of agreement with the following statement - People who don't
get ahead should blame themselves, not the system: Strongly disagree, Disagree,
Don't know, Agree, Strongly agree.}
\item{poorgap}{How much should be done to reduce the gap between rich and poor in
Canada - Much less, Somewhat less, About the same/Don't know, Somewhat more, Much more.}
\item{stayhome}{Level of agreement with the following statement - Society would be better
off if fewer women worked outside the home: Strongly disagree, Disagree, Don't know,
Agree, Strongly agree.}
\item{feelgays}{Feeling thermometer for homosexuals.}
\item{dowomen}{How much do you think should be done for women: Much less, Somewhat less,
About the same/Don't know, Somewhat more, Much more.}
\item{leader_lib}{Feeling thermometer for Justin Trudeau, leader of the Liberal Party.}
\item{leader_con}{Feeling thermometer for Andrew Scheer, leader of the Conservative Party.}
\item{leader_ndp}{Feeling thermometer for Jagmeet Singh, leader of the NDP.}
\item{leader_bloc}{Feeling thermometer for Yves-Francois Blanchet, the leader of the Bloc Quebecois.}
\item{market}{Market liberalism – additive scale of jobspriv, poorgap and blame variables.}
\item{moral}{Moral traditionalism – additive scale of dowomen, stayhome and feelgays.}
\item{union}{Whether respondent is a union member - yes or no.}
\item{weight_CES}{Weighting variable for the CES.}
}
}
\description{
These data are a subset of the Canadian Election Study telephone
sample (Stephenson et. al. 2020).
}
\references{
Stephenson, Laura B,  Allison Harell, Daniel Rubenson, Peter John Loewen.  (2020). "2019 Canadian Election Study - Phone Survey", \doi{https://doi.org/10.7910/DVN/8RHLG1}, Harvard Dataverse, V1.
}
\keyword{datasets}
