% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_coxr.R
\name{psfmi_coxr}
\alias{psfmi_coxr}
\title{Pooling and predictor selection function for Cox regression
models in multiply imputed datasets}
\usage{
psfmi_coxr(data, nimp = 5, impvar = NULL, time, status,
  predictors = NULL, p.crit = 1, cat.predictors = NULL,
  spline.predictors = NULL, int.predictors = NULL,
  keep.predictors = NULL, knots = NULL, method = NULL,
  print.method = FALSE)
}
\arguments{
\item{data}{Data frame or data matrix with stacked multiple imputed
datasets.
  The original dataset that contains missing values must be excluded from the dataset. The imputed
  datasets must be distinguished by an imputation variable, specified under impvar, and starting by 1.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the imputed datasets.}

\item{time}{Follow up time.}

\item{status}{The status variable, normally 0=censoring, 1=event.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined.}

\item{p.crit}{A numerical scalar. P-value selection criterium.}

\item{cat.predictors}{A single string or a vector of strings to define the categorical variables.
Default is NULL categorical predictors.}

\item{spline.predictors}{A single string or a vector of strings to define the
(restricted cubic) spline variables. Default is NULL spline predictors.}

\item{int.predictors}{A single string or a vector of strings with the names of the variables that form
an interaction pair, separated by a “:” symbol.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. Categorical and interaction variables are allowed. See details.}

\item{knots}{A numerical vector that defines the number of knots for each spline predictor separately.}

\item{method}{A character vector to indicate the pooling method for p-values to pool the
total model or used during predictor selection. This can be "D1", "D2", or "MPR".
See details for more information.}

\item{print.method}{logical vector. If TRUE full matrix with p-values of all variables according to
chosen method (under method) is shown. If FALSE (default) p-value for categorical variables according
to method are shown and for continuous and dichotomous predictors Rubin’s Rules are used.}
}
\value{
A \code{psfmi_coxr} object from which the following objects can be extracted: pooled model as 
 \code{RR_model}, pooled p-values according to pooling method as \code{multiparm_p}, predictors 
 excluded at each step as \code{coef.excl_step}, and \code{impvar}, \code{nimp}, \code{method}, 
 \code{p.crit}, \code{predictors}, \code{cat.predictors}, \code{keep.predictors}, \code{int.predictors},
 \code{spline.predictors}, \code{knots}, \code{print.method}.
}
\description{
\code{psfmi_coxr} Pooling and backward selection for Cox regression
models in multiply imputed datasets using different selection methods.
}
\details{
The basic pooling procedure to derive pooled coefficients, standard errors, 95
 confidence intervals and p-values is Rubin's Rules (RR). Specific procedures are
 available to derive pooled p-values for categorical (> 2 categories) and spline variables.
 print.method allows to choose between these pooling methods that are:
 “D1” is pooling of the total covariance matrix, ”D2” is pooling of Chi-square values,
 and “MPR” is pooling of median p-values (MPR rule). Spline regression coefficients are defined
 by using the rcs function for restricted cubic splines of the rms package of Frank Harrell.
 A minimum number of 3 knots as defined under knots is needed.
}
\examples{
  pool_coxr <- psfmi_coxr(data=lbpmicox, nimp=5, impvar="Impnr", time="Time", 
  status="Status", predictors=c("Duration", "Radiation", "Onset"), p.crit=1, 
  method="D1", cat.predictors=c("Expect_cat"))
  pool_coxr$RR_Model
  pool_coxr$multiparm_p
  
  pool_coxr <- psfmi_coxr(data=lbpmicox, nimp=5, impvar="Impnr", time="Time", 
  status="Status", predictors=c("Previous",  "Radiation", "Onset",
  "Function", "Tampascale" ), p.crit=0.05, cat.predictors=c("Expect_cat"), 
  int.predictors=c("Tampascale:Radiation",
  "Expect_cat:Tampascale"), keep.predictors = "Tampascale", method="D2")
  pool_coxr$RR_Model
  pool_coxr$multiparm_p
  
}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Enders CK (2010). Applied missing data analysis. New York: The Guilford Press.

van de Wiel MA, Berkhof J, van Wieringen WN. Testing the prediction error difference between
  2 predictors. Biostatistics. 2009;10:550-60.

Marshall A, Altman DG, Holder RL, Royston P. Combining estimates of interest in prognostic
  modelling studies after multiple imputation: current practice and guidelines. BMC Med Res Methodol.
  2009;9:57.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
  Interdisciplinary Statistics. Boca Raton.

http://missingdatasolutions.rbind.io/
}
