% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rename_draws_covariates}
\alias{rename_draws_covariates}
\title{Rename Covariates in \code{draws} Object}
\usage{
rename_draws_covariates(draws, analysis)
}
\arguments{
\item{draws}{\code{draws} created from sampled analysis object. See example.}

\item{analysis}{\code{Analysis} as created by \code{\link[=create_analysis_obj]{create_analysis_obj()}}.}
}
\value{
A \code{draws}[\link[posterior:draws]{posterior::draws}] object with covariate names.
}
\description{
Rename Covariates in \code{draws} Object
}
\examples{
if (check_cmdstan()) {
  analysis_object <- create_analysis_obj(
    data_matrix = example_matrix,
    covariates = add_covariates(
      covariates = c("cov1", "cov2"),
      priors = prior_normal(0, 1000)
    ),
    outcome = outcome_surv_exponential(
      "time",
      "cnsr",
      baseline_prior = prior_normal(0, 1000)
    ),
    borrowing = borrowing_hierarchical_commensurate(
      "ext",
      prior_exponential(.001)
    ),
    treatment = treatment_details(
      "trt",
      prior_normal(0, 1000)
    )
  )
  samples <- mcmc_sample(analysis_object, 200, 400, 1)
  draws <- samples$draws()
  renamed_draws <- rename_draws_covariates(draws, analysis_object)
  summary(renamed_draws)
}
}
