% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_exe}
\alias{ps_exe}
\title{Full path of the executable of a process}
\usage{
ps_exe(p)
}
\arguments{
\item{p}{Process handle.}
}
\value{
Character scalar.
}
\description{
Path to the executable of the process. May also be an empty string or
\code{NA} if it cannot be determined.
}
\details{
For a zombie process it throws a \code{zombie_process} error.
}
\seealso{
Other process handle functions: \code{\link{ps_children}},
  \code{\link{ps_cmdline}}, \code{\link{ps_cpu_times}},
  \code{\link{ps_create_time}}, \code{\link{ps_cwd}},
  \code{\link{ps_environ}}, \code{\link{ps_handle}},
  \code{\link{ps_is_running}}, \code{\link{ps_kill}},
  \code{\link{ps_memory_info}}, \code{\link{ps_name}},
  \code{\link{ps_num_threads}}, \code{\link{ps_pid}},
  \code{\link{ps_ppid}}, \code{\link{ps_resume}},
  \code{\link{ps_send_signal}}, \code{\link{ps_status}},
  \code{\link{ps_suspend}}, \code{\link{ps_terminal}},
  \code{\link{ps_terminate}}, \code{\link{ps_uids}},
  \code{\link{ps_username}}
}
\section{Examples}{
\Sexpr[stage=install,strip.white=FALSE,results=rd]{ps:::decorate_examples('
p <- ps_handle()
p
ps_name(p)
ps_exe(p)
ps_cmdline(p)
')}
}
