% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_alphafold_aligned_error.R
\name{fetch_alphafold_aligned_error}
\alias{fetch_alphafold_aligned_error}
\title{Fetch AlphaFold aligned error}
\usage{
fetch_alphafold_aligned_error(
  uniprot_ids = NULL,
  error_cutoff = 20,
  timeout = 30,
  max_tries = 1,
  return_data_frame = FALSE,
  show_progress = TRUE
)
}
\arguments{
\item{uniprot_ids}{a character vector of UniProt identifiers for which predictions
should be fetched.}

\item{error_cutoff}{a numeric value specifying the maximum position error (in Angstroms) that should be retained.
setting this value to a low number reduces the size of the retrieved data. Default is 20.}

\item{timeout}{a numeric value specifying the time in seconds until the download times out.
The default is 30 seconds.}

\item{max_tries}{a numeric value that specifies the number of times the function tries to download
the data in case an error occurs. The default is 1.}

\item{return_data_frame}{a logical value; if \code{TRUE} a data frame instead of a list
is returned. It is recommended to only use this if information for few proteins is retrieved.
Default is \code{FALSE}.}

\item{show_progress}{a logical value; if \code{TRUE} a progress bar will be shown.
Default is \code{TRUE}.}
}
\value{
A list that contains aligned errors for AlphaFold predictions. If return_data_frame is
TRUE, a data frame with this information is returned instead. The data frame contains the
following columns:
\itemize{
\item scored_residue: The error for this position is calculated based on the alignment to the
aligned residue.
\item aligned_residue: The residue that is aligned for the calculation of the error of the scored
residue
\item error: The predicted aligned error computed by alpha fold.
\item accession: The UniProt protein identifier.
}
}
\description{
Fetches the aligned error for AlphaFold predictions for provided proteins.
The aligned error is useful for assessing inter-domain accuracy. In detail it
represents the expected position error at residue x (scored residue), when
the predicted and true structures are aligned on residue y (aligned residue).
}
\examples{
\donttest{
aligned_error <- fetch_alphafold_aligned_error(
  uniprot_ids = c("F4HVG8", "O15552"),
  error_cutoff = 5,
  return_data_frame = TRUE
)

head(aligned_error, n = 10)
}
}
