% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_sequence_coverage.R
\name{calculate_sequence_coverage}
\alias{calculate_sequence_coverage}
\title{Protein sequence coverage}
\usage{
calculate_sequence_coverage(data, protein_sequence, peptides)
}
\arguments{
\item{data}{a data frame containing at least the protein sequence and the identified peptides
as columns.}

\item{protein_sequence}{a character column in the \code{data} data frame that contains protein
sequences. Can be obtained by using the function \code{fetch_uniprot()}}

\item{peptides}{a character column in the \code{data} data frame that contains the identified
peptides.}
}
\value{
A new column in the \code{data} data frame containing the calculated sequence coverage
for each identified protein
}
\description{
Calculate sequence coverage for each identified protein.
}
\examples{
data <- data.frame(
  protein_sequence = c("abcdefghijklmnop", "abcdefghijklmnop"),
  pep_stripped_sequence = c("abc", "jklmn")
)

calculate_sequence_coverage(
  data,
  protein_sequence = protein_sequence,
  peptides = pep_stripped_sequence
)
}
