% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_data_completeness.R
\name{qc_data_completeness}
\alias{qc_data_completeness}
\title{Data completeness}
\usage{
qc_data_completeness(
  data,
  sample,
  grouping,
  intensity,
  digestion = NULL,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{A data frame containing at least the input variables.}

\item{sample}{The name of the column containing the sample names.}

\item{grouping}{The name of the column containing either precursor or peptide identifiers.}

\item{intensity}{The name of the column containing any intensity intensity values that missingness should be determined for.}

\item{digestion}{Optional column indicating the mode of digestion (limited proteolysis or tryptic digest). Alternatively, any other variable
by which the data should be split can be provided.}

\item{plot}{Logical, if TRUE a plot is returned. If FALSE a table is returned.}

\item{interactive}{Logical, if TRUE the plot is interactive using plotly.}
}
\value{
A bar plot that displays the percentage of data completeness over all samples. If \code{plot = FALSE} a data frame is returned.
If \code{interactive = TRUE}, the plot is interactive.
}
\description{
Calculates the percentage of data completeness. That means, what percentage of all detected precursors is present in each sample.
}
\examples{
\dontrun{
qc_data_completeness(
  data,
  sample = r_file_name,
  grouping = eg_precursor_id,
  intensity = fg_quantity,
  digestion = digestion
)
}
}
