% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geobuf.R
\name{geobuf}
\alias{geobuf}
\alias{read_geobuf}
\alias{geobuf2json}
\alias{json2geobuf}
\title{Geobuf}
\usage{
read_geobuf(x, as_data_frame = TRUE)

geobuf2json(x, pretty = FALSE)

json2geobuf(json, decimals = 6)
}
\arguments{
\item{x}{file path or raw vector with the serialized \code{geobuf.proto} message}

\item{as_data_frame}{simplify geojson data into data frames}

\item{pretty}{indent json, see \link[jsonlite:toJSON]{jsonlite::toJSON}}

\item{json}{a text string with geojson data}

\item{decimals}{how many decimals (digits behind the dot) to store for numbers}
}
\description{
The \href{https://github.com/mapbox/geobuf}{geobuf} format is an optimized
binary format for storing \code{geojson} data with protocol buffers. These
functions are compatible with the \code{geobuf2json} and \code{json2geobuf}
utilities from the geobuf \href{https://www.npmjs.com/package/geobuf}{npm package}.
}
