% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-pra.R
\name{pra}
\alias{pra}
\title{Principal Ratio Analysis}
\usage{
pra(counts, ndim = 3, nclust = 2 * round(sqrt(ncol(counts))),
  nsearch = 3, ndenom = 4)
}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns. Note that this matrix
does not necessarily have to contain counts.}

\item{ndim}{An integer. The number of ratios to find.}

\item{nclust}{An integer. The number of clusters to build from the data.}

\item{nsearch}{An integer. The number of clusters to search exhaustively.}

\item{ndenom}{An integer. The number of best denominators to use
when searching for the best numerators.}
}
\value{
A list of: (1) "best", the best ratios and the variance they explain,
 (2) "all", all ratios tested and the variance they explain,
 (3) "Z", the standardized data used by the constrained PCA, and
 (4) "Y", the final ratios used to constrain the PCA.
}
\description{
This function finds which feature ratios explain the most variance.
 This is a computationally expensive procedure that we approximate
 with the heuristic described below.
}
\details{
This function resembles the method described by Michael Greenacre
 in "Variable Selection in Compositional Data Analysis Using
 Pairwise Logratios", except that we have modified the method
 to use a heuristic that scales to high-dimensional data.

For each ratio, the heuristic will search CLR-based clusters
 for the best denominator, and then will search ALR-based clusters
 for the best numerator. It does this by dividing the
 transformed data into \code{nclust} clusters, calculating
 \code{vegan::rda} on the geometric mean of each cluster, then
 searching the best clusters exhaustively. The \code{ndenom}
 argument toggles how many best denominators to use during the
 next step. This process is repeated \code{ndim} times, finding
 that number of ratios that explain the most variance.
}
