<!-- README.md is generated from README.Rmd. Please edit that file -->
Quick start
-----------

Welcome to the `propr` GitHub page!

The bioinformatic evaluation of gene co-expression often begins with correlation-based analyses. However, this approach lacks statistical validity when applied to relative data. This includes, for example, biological count data generated by high-throughput RNA-sequencing, chromatin immunoprecipitation (ChIP), ChIP-sequencing, Methyl-Capture sequencing, and other techniques. This package implements several metrics for proportionality, including phi \[Lovell et al (2015)\] and rho \[Erb and Notredame (2016)\]. This package also implements several metrics for differential proportionality. Unlike correlation, these measures give the same result for both relative and absolute data.

``` r
library(devtools)
devtools::install_github("tpq/propr")
library(propr)
```

Further reading
---------------

To learn more about proportionality, we refer the reader to the relevant literature.

``` r
citation("propr")
```

    ## 
    ## To cite propr in publications use:
    ## 
    ##   Quinn T, Richardson MF, Lovell D, Crowley T (2017) propr: An
    ##   R-package for Identifying Proportionally Abundant Features Using
    ##   Compositional Data Analysis. bioRxiv: doi:10.1101/104935
    ## 
    ##   Erb I, Quinn T, Lovell D, Notredame C (2017) Differential
    ##   Proportionality - A Normalization-Free Approach To Differential
    ##   Gene Expression. bioRxiv: doi:10.1101/134536
    ## 
    ##   Lovell D, Pawlowsky-Glahn V, Egozcue JJ, Marguerat S, Bahler J
    ##   (2015) Proportionality: A Valid Alternative to Correlation for
    ##   Relative Data. PLoS Comput Biol 11(3):
    ##   doi:10.1371/journal.pcbi.1004075
    ## 
    ##   Erb I, Notredame C (2016) How should we measure proportionality
    ##   on relative gene expression data? Theory Biosci 135(1):
    ##   doi:10.1007/s12064-015-0220-8
