% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/301.Expec_Leng_BASE_All.R
\name{lengthWD}
\alias{lengthWD}
\title{Expected length and sum of length of  Wald method}
\usage{
lengthWD(n, alp, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\value{
A dataframe with
 \item{sumLen}{  The sum of the expected length}
 \item{explMean}{  The mean of the expected length}
 \item{explSD}{  The Standard Deviation of the expected length}
 \item{explMax}{  The max of the expected length}
 \item{explLL}{  The Lower limit of the expected length calculated using mean - SD}
 \item{explUL}{  The Upper limit of the expected length calculated using mean + SD}
}
\description{
Expected length and sum of length of  Wald method
}
\details{
Evaluation of Wald-type intervals using sum of length of the \eqn{n + 1}
 intervals
}
\examples{
n=5; alp=0.05;a=1;b=1
lengthWD(n,alp,a,b)
}
\references{
[1] 1993 Vollset SE.
Confidence intervals for a binomial proportion.
Statistics in Medicine: 12; 809 - 824.

[2] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[3] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[4] 2001 Brown LD, Cai TT and DasGupta A.
Interval estimation for a binomial proportion.
Statistical Science: 16; 101 - 133.

[5] 2002 Pan W.
Approximate confidence intervals for one proportion and difference of two proportions
Computational Statistics and Data Analysis 40, 128, 143-157.

[6] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.

[7] 2014 Martin Andres, A. and Alvarez Hernandez, M.
Two-tailed asymptotic inferences for a proportion.
Journal of Applied Statistics, 41, 7, 1516-1529
}
\seealso{
Other Expected length  of base methods: \code{\link{PlotexplAS}},
  \code{\link{PlotexplAll}}, \code{\link{PlotexplBA}},
  \code{\link{PlotexplEX}}, \code{\link{PlotexplLR}},
  \code{\link{PlotexplLT}}, \code{\link{PlotexplSC}},
  \code{\link{PlotexplTW}}, \code{\link{PlotexplWD}},
  \code{\link{PlotlengthAS}}, \code{\link{PlotlengthAll}},
  \code{\link{PlotlengthBA}}, \code{\link{PlotlengthEX}},
  \code{\link{PlotlengthLR}}, \code{\link{PlotlengthLT}},
  \code{\link{PlotlengthSC}}, \code{\link{PlotlengthTW}},
  \code{\link{PlotlengthWD}}, \code{\link{lengthAS}},
  \code{\link{lengthAll}}, \code{\link{lengthBA}},
  \code{\link{lengthEX}}, \code{\link{lengthLR}},
  \code{\link{lengthLT}}, \code{\link{lengthSC}},
  \code{\link{lengthTW}}
}

