% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{init_refmodel}
\alias{init_refmodel}
\title{Generic reference model initialization}
\usage{
init_refmodel(x, y, family, predfun = NULL, dis = NULL, offset = NULL,
  wobs = NULL, wsample = NULL, intercept = TRUE, cvfits = NULL)
}
\arguments{
\item{x}{Predictor matrix of dimension \code{n}-by-\code{D} containing the candidate
variables for selection (i.e. variables from which to select the submodel). Rows denote
the observations and columns the different variables.}

\item{y}{Vector of length \code{n} giving the target variable values.}

\item{family}{\link{family} object giving the model family}

\item{predfun}{Function that takes a \code{nt}-by-\code{D} test predictor matrix as an input
(\code{nt} = # test points, \code{D} = # predictors) and outputs
a \code{nt}-by-\code{S} matrix of expected values for the target variable y,
each column corresponding to one posterior draw for the parameters in the reference model
(the number of draws \code{S} can also be 1).
The output should be computed without any offsets, these are automatically taken into account
internally, e.g. in cross-validation.}

\item{dis}{Vector of length \code{S} giving the posterior draws for the dispersion parameter
in the reference model if there is such a parameter in the model family. For Gaussian
observation model this is the noise std \code{sigma}.}

\item{offset}{Offset to be added to the linear predictor in the projection. (Same as in
function \code{glm}.)}

\item{wobs}{Observation weights. If omitted, equal weights are assumed.}

\item{wsample}{vector of length \code{S} giving the weights for the posterior draws. 
If omitted, equal weights are assumed.}

\item{intercept}{Whether to use intercept. Default is \code{TRUE}.}

\item{cvfits}{A list with K elements, each of which is a list with fields including at least
variables: tr, ts and predfun giving the training and test indices and prediction function
for each fold. Additionally each element can have field dis (dispersion samples for each fold)
if the model has a dispersion parameter. Can be omitted but needed for K-fold cross validation
for genuine reference models.}
}
\value{
An object that can be passed to all the functions that
take the reference fit as the first argument, such as \link{varsel}, \link{cv_varsel},
\link[=proj-pred]{proj_predict} and \link[=proj-pred]{proj_linpred}.
}
\description{
Initializes a structure that can be used as a reference fit for the
projective variable selection.
This function is provided to allow construction of the reference fit
using also other tools than \code{rstanarm}, because only certain specific
information is needed for the actual projection and variable selection.
}
