% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.R
\name{post_issue}
\alias{post_issue}
\title{Post issue to GitHub repository}
\usage{
post_issue(ref, title, ..., distinct = TRUE)
}
\arguments{
\item{ref}{Repository reference (list) created by \code{create_repo_ref()}}

\item{title}{Issue title (required)}

\item{...}{Additional user-defined body parameters. Use \code{browse_docs()} to learn more.}

\item{distinct}{Logical value to denote whether issues with the same title
as a current open issue should be allowed}
}
\value{
Number (identifier) of posted issue
}
\description{
Post issue to GitHub repository
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
post_issue(myrepo,
  title = 'this is the issue title',
  body = 'this is the issue body',
  labels = c('priority:high', 'bug'))
}
\dontrun{
# can be used in conjunction with reprex pkg
# example assumes code for reprex is on clipboard
reprex::reprex(venue = "gh")
post_issue(myrepo,
            title = "something is broken",
            body = paste( clipr::read_clip(), collapse = "\\n") )
}
}
\seealso{
Other issues: \code{\link{get_issue_comments}},
  \code{\link{get_issue_events}}, \code{\link{get_issues}},
  \code{\link{parse_issue_comments}},
  \code{\link{parse_issue_events}},
  \code{\link{parse_issues}},
  \code{\link{report_discussion}},
  \code{\link{report_progress}},
  \code{\link{viz_waterfall}}
}
\concept{issues}
