% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibility.R
\name{export_project}
\alias{export_project}
\title{Compressed a project folder}
\usage{
export_project(project, zipfile, include_hidden = FALSE,
  exclude = NULL)
}
\arguments{
\item{project}{Project \code{id} or unambiguous substring of the project name
from the \code{\link{projects}()} table.}

\item{zipfile}{Desired file path of the resulting compressed folder file,
including the file's desired name and file extension. See the
\code{zipfile} argument for the \code{zip::\link[zip]{zipr}()} function.}

\item{include_hidden}{Logical indicating whether or not to include hidden
folders and files (e.g., those with names that begin with a period).
Defaults to \code{FALSE}.}

\item{exclude}{Character vector of exact names of first-level subdirectories
of the project folder to exclude from the resulting compressed folder file.}
}
\value{
The name of the created zip file, invisibly.
}
\description{
Creates a compressed file out of a user-specified project folder for sharing.
}
\details{
Currently, this function uses \code{zip::\link[zip]{zipr}()}.
}
