% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Run external command, and wait until finishes}
\usage{
run(command = NULL, args = character(), error_on_status = TRUE,
  wd = NULL, echo_cmd = FALSE, echo = FALSE, spinner = FALSE,
  timeout = Inf, stdout_line_callback = NULL, stdout_callback = NULL,
  stderr_line_callback = NULL, stderr_callback = NULL,
  windows_verbatim_args = FALSE, windows_hide_window = FALSE,
  encoding = "")
}
\arguments{
\item{command}{Character scalar, the command to run. It will be
escaped via \link[base:shQuote]{base::shQuote}.}

\item{args}{Character vector, arguments to the command. They will be
escaped via \link[base:shQuote]{base::shQuote}.}

\item{error_on_status}{Whether to throw an error if the command returns
with a non-zero status, or it is interrupted. The error clases are
\code{system_command_status_error} and \code{system_command_timeout_error},
respectively, and both errors have class \code{system_command_error} as
well.}

\item{wd}{Working directory of the process. If \code{NULL}, the current
working directory is used.}

\item{echo_cmd}{Whether to print the command to run to the screen.}

\item{echo}{Whether to print the standard output and error
to the screen. Note that the order of the standard output and error
lines are not necessarily correct, as standard output is typically
buffered.}

\item{spinner}{Whether to show a reassuring spinner while the process
is running.}

\item{timeout}{Timeout for the process, in seconds, or as a \code{difftime}
object. If it is not finished before this, it will be killed.}

\item{stdout_line_callback}{\code{NULL}, or a function to call for every
line of the standard output. See \code{stdout_callback} and also more
below.}

\item{stdout_callback}{\code{NULL}, or a function to call for every chunk
of the standard output. A chunk can be as small as a single character.
At most one of \code{stdout_line_callback} and \code{stdout_callback} can be
non-\code{NULL}.}

\item{stderr_line_callback}{\code{NULL}, or a function to call for every
line of the standard error. See \code{stderr_callback} and also more
below.}

\item{stderr_callback}{\code{NULL}, or a function to call for every chunk
of the standard error. A chunk can be as small as a single character.
At most one of \code{stderr_line_callback} and \code{stderr_callback} can be
non-\code{NULL}.}

\item{windows_verbatim_args}{Whether to omit the escaping of the
command and the arguments on windows. Ignored on other platforms.}

\item{windows_hide_window}{Whether to hide the window of the
application on windows. Ignored on other platforms.}

\item{encoding}{The encoding to assume for \code{stdout} and
\code{stderr}. By default the encoding of the current locale is
used. Note that \code{processx} always reencodes the output of
both streams in UTF-8 currently.}
}
\value{
A list with components:
\itemize{
\item status The exit status of the process. If this is \code{NA}, then the
process was killed and had no exit status.
\item stdout The standard output of the command, in a character scalar.
\item stderr The standard error of the command, in a character scalar.
\item timeout Whether the process was killed because of a timeout.
}
}
\description{
\code{run} provides an interface similar to \code{\link[base:system]{base::system()}} and
\code{\link[base:system2]{base::system2()}}, but based on the \link{process} class. This allows some
extra features, see below.
}
\details{
\code{run} supports
\itemize{
\item Specifying a timeout for the command. If the specified time has
passed, and the process is still running, it will be killed
(with all its child processes).
\item Calling a callback function for each line or each chunk of the
standard output and/or error. A chunk may contain multiple lines, and
can be as short as a single character.
}
}
\section{Callbacks}{


Some notes about the callback functions. The first argument of a
callback function is a character scalar (length 1 character), a single
output or error line. The second argument is always the \link{process}
object. You can manipulate this object, for example you can call
\code{$kill()} on it to terminate it, as a response to a message on the
standard output or error.
}

\examples{
## Different examples for Unix and Windows
\dontrun{
if (.Platform$OS.type == "unix") {
  run("ls")
  system.time(run("sleep", "10", timeout = 1,
    error_on_status = FALSE))
  system.time(
    run(
      "sh", c("-c", "for i in 1 2 3 4 5; do echo $i; sleep 1; done"),
      timeout = 2, error_on_status = FALSE
    )
  )
} else {
  run("ping", c("-n", "1", "127.0.0.1"))
  run("ping", c("-n", "6", "127.0.0.1"), timeout = 1,
    error_on_status = FALSE)
}
}
}
