% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rule.R
\name{check_rule}
\alias{check_rule}
\title{Check declarative rules.}
\usage{
check_rule(eventlog, rule, label = NULL)
}
\arguments{
\item{eventlog}{Eventlog object}

\item{rule}{A rule create by a rule function.}

\item{label}{Optionally, the variable name under which the result of the rule should be stored.}
}
\value{
An annotated event log, where a new column indicates whether the rule holds or not. The name of the new column can optionally be set using the "label" argument.
}
\description{
This function can be used to check rules on event data. It needs an event log and a rule. Rules can be made with the following functions:
absent(),
and(),
contains(),
contains_between(),
contains_exactly(),
ends(),
precedence(),
response(),
responded_existence(),
starts(),
succession(),
xor().
}
\examples{
library(bupaR)
library(eventdataR)

# check whether MRI Scan is preceded by Blood test.
patients \%>\%
check_rule(precedence("Blood test","MRI SCAN"))

}
